--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNresourceList ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobjectSwitch    = 0
  local LOCresourceKitMode = 1
  local LOCresourceType    = ""
  local LOCpopupMenu       = undefined

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNquickPlacementTool FUNshapeArray FUNspeed FUNinterval FUNrotation FUNstartPercent FUNendPercent FUNiniFile FUNobjectSwitch FUNmode =
  (
    local LOCprogressPanel   = DYNFUNdisplayProgressPanel(); createDialog LOCprogressPanel width:619 height:75 modal:false
    local LOCstatusLabelCtrl = LOCprogressPanel.LBDYNstatus2
    local LOCprogressBarCtrl = LOCprogressPanel.dnProgress
    local LOCsceneMats       = sceneMaterials
    local LOCelemArray       = #(#("0.0", "0.0", (FUNinterval as string), (FUNstartPercent as string), (FUNendPercent as string), "0", (FUNrotation as string), (FUNspeed as string), FUNiniFile, (FUNobjectSwitch as string)))

    --- apply to every string in FUNshapeArray
    DYNFUNloadVSPnodeCallBacks false
    (
      with redraw off
      (
        for ii = 1 to FUNshapeArray.count do
        (
          if isValidNode FUNshapeArray[ii] and superClassOf FUNshapeArray[ii] == shape then
          (
            LOCstatusLabelCtrl.text            = DYNuiResourcesStatusMessages[24]
            LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[24]

            --- Ensure that Parent Shape is an editable spline
            DYNFUNcheckIsSplineShape FUNshapeArray[ii]

            --- Get Start Station of Current Shape
            local LOCstartStation = getAppData FUNshapeArray[ii] 426
            if classOf LOCstartStation == string then LOCstartStation = LOCstartStation as float
            if classOf LOCstartStation != float  then LOCstartStation = 0.0

            --- Check amount of available space for each element in Object Placement Style
            local LOCobjCnt = 0.0
            DYNobjectPlacer.LOCspaceCheckProceedSwitch = true
            local LOCinsertPositions = DYNFUNpreProcessOPStyle LOCelemArray (curveLength FUNshapeArray[ii]) LOCstartStation
            for iii = 1 to LOCinsertPositions.count do LOCobjCnt += LOCinsertPositions[iii].count

            --- Place Objects
            if DYNobjectPlacer.LOCspaceCheckProceedSwitch then
            (
              local LOCflagArray = #(true)
              local LOCnodeArray = #(#())
              LOCnodeArray = DYNobjectPlacer.DYNFUNplaceObjects FUNshapeArray[ii] LOCinsertPositions undefined 1 LOCprogressBarCtrl LOCelemArray LOCflagArray LOCnodeArray LOCobjCnt LOCstatusLabelCtrl LOCsceneMats (if DYNINIchainageLoop == "0" then false else true) (if DYNINIrotateWheels == "0" then false else true) DYNresourceList.LOCresourceKitMode
            )
            else
            (
              print DYNuiResourcesErrorsWarnings[73]
            )
          )
        )
      )
      redrawViews()
    )
    DYNFUNloadVSPnodeCallBacks true
    DYNFUNnodeCreatedCallback()
    DYNproperties.DYNFUNscreenSelectionToList()

    destroyDialog LOCprogressPanel
  )

  fn DYNFUNpopulateResourceList FUNobjectSwitch FUNcolumnHeaderText FUNresourceType FUNmode =
  (
    if DYNresourceList.open == true then
    (
      local LOClistItemRange          = #()
      DYNresourceList.LOCobjectSwitch    = FUNobjectSwitch
      DYNresourceList.LOCresourceKitMode = FUNmode
      DYNresourceList.LOCresourceType    = FUNresourceType
      DYNresourceList.dnResources.items.clear()

      --- Populate LV with Styles ----------------------------------------------------------------
      if FUNobjectSwitch == 0 then
      (
        local LOCfileArray    = #()
        local LOCpath         = ""
        DYNresourceList.title = DYNuiRolloutNames[61]

        if FUNresourceType == "BOS" then (LOCfileArray = DYNFUNgetAllResourceKitStyles DYNlocalBosPath; LOCpath = subString DYNlocalBosPath 1 (DYNlocalBosPath.count - 5))
        if FUNresourceType == "OPS" then (LOCfileArray = DYNFUNgetAllResourceKitStyles DYNlocalOpsPath; LOCpath = subString DYNlocalOpsPath 1 (DYNlocalOpsPath.count - 5))
        if FUNresourceType == "RMS" then (LOCfileArray = DYNFUNgetAllResourceKitStyles DYNlocalRmsPath; LOCpath = subString DYNlocalRmsPath 1 (DYNlocalRmsPath.count - 5))
        if FUNresourceType == "ROS" then (LOCfileArray = DYNFUNgetAllResourceKitStyles DYNlocalRosPath; LOCpath = subString DYNlocalRosPath 1 (DYNlocalRosPath.count - 5))
        if FUNresourceType == "SOS" then (LOCfileArray = DYNFUNgetAllResourceKitStyles DYNlocalSosPath; LOCpath = subString DYNlocalSosPath 1 (DYNlocalSosPath.count - 5))

        for i in LOCfileArray do
        (
          local LOClistItem

          --- Only list Country Resource Kit Styles
          if FUNmode == 1 and subString i 1 4 == "Coun" then
          (
            LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" ((filterString i "/")[2])
          )

          --- Only list Project Resource Kit Styles
          if FUNmode == 2 and subString i 1 4 == "Proj" then
          (
            LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" ((filterString i "/")[2])
          )

          --- Only list Private Resource Kit Styles
          if FUNmode == 3 and subString i 1 4 == "Priv" then
          (
            LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" ((filterString i "/")[2])
          )

          if LOClistItem != undefined then
          (
            if FUNmode == 1 then LOClistItem.tag = DYNcountryPath                     + LOCpath + ((filterString i "/")[2])
            if FUNmode == 2 then LOClistItem.tag = rootNode.DYNrootNodeStore.string02 + LOCpath + ((filterString i "/")[2])
            if FUNmode == 3 then LOClistItem.tag = DYNINIprivateKitPath               + LOCpath + ((filterString i "/")[2])
            LOClistItem.ImageIndex = 35
            append LOClistItemRange LOClistItem
          )
        )
      )

      --- Populate LV with Objects ---------------------------------------------------------------
      if FUNobjectSwitch >= 1 and FUNobjectSwitch <= 6 then
      (
        DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
        local LOCobjectArray  = DYNFUNiniGetBases FUNobjectSwitch FUNmode
        DYNresourceList.title = DYNuiRolloutNames[62]

        for i in LOCobjectArray do
        (
          local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" i
          LOClistItem.tag        = (DYNFUNsetINIpath FUNObjectSwitch FUNmode) + i + ".ini"
          LOClistItem.ImageIndex = FUNobjectSwitch
          append LOClistItemRange LOClistItem
        )
      )

      --- Finalise LV ----------------------------------------------------------------------------
      if FUNcolumnHeaderText != undefined then (DYNresourceList.dnResources.Columns.item[0].text = FUNcolumnHeaderText)
      DYNresourceList.dnResources.Items.AddRange LOClistItemRange
      DYNresourceList.dnResources.refresh()
    )
  )

  fn DYNFUNresourcePopUpMenu FUNlv =
  (
    DYNresourceList.LOCpopupMenu = undefined
    if DYNresourceList.dnResources.SelectedItems.count == 1 then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  fn DYNFUNstyleMode  = (DYNresourceList.LOCobjectSwitch == 0)\n"
      LOCexe += "  fn DYNFUNobjectMode = (DYNresourceList.LOCobjectSwitch >= 1 and DYNresourceList.LOCobjectSwitch <= 6)\n"
      LOCexe += "\n"
      LOCexe += "  local LOCshapeArray = #()\n"
      LOCexe += "  local LOCbasicArray = getCurrentSelection()\n"
      LOCexe += "  local LOCstyleFile = \"\"\n"
      LOCexe += "  local LOCstyleType = \"\"\n"
      LOCexe += "  local LOCiniFile   = \"\"\n"
      LOCexe += "\n"
      LOCexe += "  menuItem MNDYNedit1      checked:false filter:DYNFUNstyleMode\n"
      LOCexe += "  separator MNDYNsep00                   filter:DYNFUNstyleMode\n"
      LOCexe += "  menuItem MNDYNapply      checked:false filter:DYNFUNstyleMode\n"
      LOCexe += "\n"
      LOCexe += "  menuItem MNDYNedit2      checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "  separator MNDYNsep01z                  filter:DYNFUNobjectMode\n"
      LOCexe += "\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[10] + "\" filter:DYNFUNobjectMode\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNplace01 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "    menuItem  MNDYNplace02 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "    menuItem  MNDYNplace03 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "    separator MNDYNsep03                 filter:DYNFUNobjectMode\n"
      LOCexe += "    menuItem  MNDYNplace04 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "    menuItem  MNDYNplace05 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "    separator MNDYNsep04                 filter:DYNFUNobjectMode\n"
      LOCexe += "    menuItem  MNDYNplace06 checked:false filter:DYNFUNobjectMode\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  separator MNDYNsep02x\n"
      LOCexe += "  menuItem MNDYNrefresh    checked:false\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNedit1.text   = DYNuiResourcesMenus[115]\n"
      LOCexe += "    MNDYNapply.text   = DYNuiResourcesMenus[116]\n"
      LOCexe += "    MNDYNedit2.text   = DYNuiResourcesMenus[117]\n"
      LOCexe += "    MNDYNplace01.text = DYNuiResourcesMenus[118]\n"
      LOCexe += "    MNDYNplace02.text = DYNuiResourcesMenus[119]\n"
      LOCexe += "    MNDYNplace03.text = DYNuiResourcesMenus[120]\n"
      LOCexe += "    MNDYNplace04.text = DYNuiResourcesMenus[121]\n"
      LOCexe += "    MNDYNplace05.text = DYNuiResourcesMenus[122]\n"
      LOCexe += "    MNDYNplace06.text = DYNuiResourcesMenus[123]\n"
      LOCexe += "    MNDYNrefresh.text = DYNuiResourcesMenus[2]\n"
      LOCexe += "\n"
      LOCexe += "    for i in LOCbasicArray do if superClassOf i == shape then append LOCshapeArray i\n"
      LOCexe += "    local LOCenableShapeItems = LOCshapeArray.count > 0\n"
      LOCexe += "\n"
      LOCexe += "    LOCstyleFile = DYNresourceList.dnResources.SelectedItems.item[0].tag\n"
      LOCexe += "    LOCstyleType = DYNFUNlowerCase (getFileNameType LOCstyleFile)\n"
      LOCexe += "    LOCiniFile   = DYNresourceList.dnResources.SelectedItems.item[0].text\n"
      LOCexe += "\n"
      LOCexe += "    MNDYNedit1.enabled = true\n"
      LOCexe += "    if LOCstyleType == \".bos\" and DYNbuildingObjects.open then MNDYNedit1.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".ops\" and DYNobjectPlacer.open    then MNDYNedit1.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".rms\" and DYNroadMarkings.open    then MNDYNedit1.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".ros\" and DYNgRailObjects.open    then MNDYNedit1.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".sos\" and DYNsweptObjects.open    then MNDYNedit1.enabled = false\n"
      LOCexe += "\n"
      LOCexe += "    MNDYNapply.enabled = LOCenableShapeItems\n"
      LOCexe += "    if LOCstyleType == \".bos\" and DYNbuildingObjects.open then MNDYNapply.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".ops\" and DYNobjectPlacer.open    then MNDYNapply.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".rms\" and DYNroadMarkings.open    then MNDYNapply.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".ros\" and DYNgRailObjects.open    then MNDYNapply.enabled = false\n"
      LOCexe += "    if LOCstyleType == \".sos\" and DYNsweptObjects.open    then MNDYNapply.enabled = false\n"
      LOCexe += "\n"
      LOCexe += "    MNDYNplace01.enabled      = LOCenableShapeItems\n"
      LOCexe += "    MNDYNplace02.enabled      = LOCenableShapeItems\n"
      LOCexe += "    MNDYNplace03.enabled      = LOCenableShapeItems\n"
      LOCexe += "    MNDYNplace04.enabled      = LOCenableShapeItems\n"
      LOCexe += "    MNDYNplace05.enabled      = LOCenableShapeItems\n"
      LOCexe += "    MNDYNplace06.enabled      = LOCenableShapeItems\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNedit1  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    --- Open Selected DVSP Style ---------------------------------------------\n"
      LOCexe += "    if LOCstyleType == \".bos\" then (DYNFUNopenBuildingObjectsPanel(); DYNbuildingObjects.DYNFUNopenBOSfile LOCstyleFile DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "    if LOCstyleType == \".ops\" then (DYNFUNopenObjectPlacerPanel()   ; if DYNobjectPlacer.open then (DYNobjectPlacer.DYNFUNopenOPSfile LOCstyleFile DYNresourceList.LOCresourceKitMode))\n"
      LOCexe += "    if LOCstyleType == \".rms\" then (DYNFUNopenRoadMarkingsPanel()   ; DYNroadMarkings.DYNFUNopenRMSfile    LOCstyleFile DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "    if LOCstyleType == \".ros\" then (DYNFUNopengRailObjectsPanel()   ; DYNgRailObjects.DYNFUNopenROSfile    LOCstyleFile DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "    if LOCstyleType == \".sos\" then (DYNFUNopenSweptObjectsPanel()   ; DYNsweptObjects.DYNFUNopenSOSfile    LOCstyleFile DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNrefresh picked do (DYNresourceList.DYNFUNpopulateResourceList DYNresourceList.LOCobjectSwitch undefined DYNresourceList.LOCresourceType DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "\n"
      LOCexe += "  --- Place at Start Point\n"
      LOCexe += "  on MNDYNplace01 picked do (DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray 0.0 0 0   0.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "\n"
      LOCexe += "  --- Place at Mid Point\n"
      LOCexe += "  on MNDYNplace02 picked do (DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray 0.0 0 0  50.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "\n"
      LOCexe += "  --- Place at End Point\n"
      LOCexe += "  on MNDYNplace03 picked do (DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray 0.0 0 0 100.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode)\n"
      LOCexe += "\n"
      LOCexe += "  --- Regular Interval\n"
      LOCexe += "  on MNDYNplace04 picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCinterval = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[45] (DYNuiResourcesLabels[485] + \" (\" + (DYNFUNlinearUnitsName()) + \"):\") [0.1,100000.0,50.0] \"float\"\n"
      LOCexe += "    if LOCinterval != undefined then\n"
      LOCexe += "    (\n"
      LOCexe += "      DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray 0.0 LOCinterval 0 0.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  --- Random Spacing\n"
      LOCexe += "  on MNDYNplace05 picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCcount    = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[45] DYNuiResourcesLabels[484] [1,1000,1] \"integer\"\n"
      LOCexe += "    if LOCcount != undefined then\n"
      LOCexe += "    (\n"
      LOCexe += "      DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray 0.0 -LOCcount 0 0.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNedit2 picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNFUNopenResourceManager DYNresourceList.LOCobjectSwitch LOCiniFile\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  --- Constant Speed\n"
      LOCexe += "  on MNDYNplace06 picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCspeed    = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[45] (DYNuiResourcesLabels[483] + \" (\" + DYNuiResourcesUnitsDistance[DYNINIspeedValue.x] + \"/\" + DYNuiResourcesUnitsTime[DYNINIspeedValue.y] + \"):\") [-9999.0,9999.0,0.0] \"float\"\n"
      LOCexe += "    if LOCspeed != undefined then\n"
      LOCexe += "    (\n"
      LOCexe += "      DYNresourceList.DYNFUNquickPlacementTool LOCshapeArray LOCspeed 0 0 0.0 100.0 LOCiniFile DYNresourceList.LOCobjectSwitch DYNresourceList.LOCresourceKitMode\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNapply  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNFUNloadVSPnodeCallBacks false\n"
      LOCexe += "    (\n"
      LOCexe += "      with redraw off\n"
      LOCexe += "      (\n"
      LOCexe += "        --- Open Selected DVSP Style ---------------------------------------------\n"
      LOCexe += "        local LOCprogressPanel   = DYNFUNdisplayProgressPanel(); createDialog LOCprogressPanel width:619 height:75 modal:false\n"
      LOCexe += "        local LOCstatusLabelCtrl = LOCprogressPanel.LBDYNstatus2\n"
      LOCexe += "        local LOCprogressBarCtrl = LOCprogressPanel.dnProgress\n"
      LOCexe += "        local LOCsceneMats       = sceneMaterials\n"
      LOCexe += "\n"
      LOCexe += "        ---- Apply Building Object Style -----------------------------------------------------------------------------------\n"
      LOCexe += "        --------------------------------------------------------------------------------------------------------------------\n"
      LOCexe += "        if doesFileExist LOCstyleFile and LOCstyleType == \".bos\" then\n"
      LOCexe += "        (\n"
      LOCexe += "          LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[13]\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Shape Label Wildcard Array from Param File Contents\n"
      LOCexe += "          local LOCelemArray = DYNFUNparsePARAMfile LOCstyleFile \"6001\"\n"
      LOCexe += "          local LOCbuildArray = #() ; LOCbuildArray[LOCelemArray.count] = undefined\n"
      LOCexe += "          for ii = 1 to LOCbuildArray.count do (LOCbuildArray[ii] = LOCelemArray[ii][1])\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Building Object if wildcard matches pattern in LOCshapeArray\n"
      LOCexe += "          for ii = 1 to LOCbuildArray.count do\n"
      LOCexe += "          (\n"
      LOCexe += "            local LOCparentArray = #()\n"
      LOCexe += "            for iii = 1 to LOCshapeArray.count do\n"
      LOCexe += "            (\n"
      LOCexe += "              if isValidNode LOCshapeArray[iii] and (DYNFUNclosedShapeFilter LOCshapeArray[iii]) then\n"
      LOCexe += "              (\n"
      LOCexe += "                LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[13]\n"
      LOCexe += "                LOCprogressBarCtrl.value = ((ii * iii) as float) / ((LOCshapeArray.count * LOCbuildArray.count) as float) * 100.0\n"
      LOCexe += "                if (matchPattern LOCshapeArray[iii].name pattern:LOCbuildArray[ii] ignoreCase:true) then (append LOCparentArray LOCshapeArray[iii])\n"
      LOCexe += "              )\n"
      LOCexe += "            )\n"
      LOCexe += "            DYNFUNcreateBuild LOCparentArray LOCstyleFile (DYNFUNgetLocalTime()) LOCsceneMats LOCelemArray[ii][2] LOCelemArray[ii][3] LOCelemArray[ii][10] LOCelemArray[ii][6] LOCelemArray[ii][4] true undefined undefined (if LOCelemArray[ii][5] == 1 then true else false)\n"
      LOCexe += "          )\n"
      LOCexe += "          LOCprogressBarCtrl.value = 0; LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[11]\n"
      LOCexe += "        )\n"
      LOCexe += "\n"
      LOCexe += "        ---- Apply Object Placement Style ----------------------------------------------------------------------------------\n"
      LOCexe += "        --------------------------------------------------------------------------------------------------------------------\n"
      LOCexe += "        if doesFileExist LOCstyleFile and LOCstyleType == \".ops\" then\n"
      LOCexe += "        (\n"
      LOCexe += "          if (DYNFUNvalidateOPSstyle LOCstyleFile true DYNresourceList.LOCresourceKitMode) then\n"
      LOCexe += "          (\n"
      LOCexe += "            local LOCelemArray = DYNFUNparsePARAMfile LOCstyleFile \"1001\"\n"
      LOCexe += "\n"
      LOCexe += "            --- apply to every string in LOCshapeArray\n"
      LOCexe += "            for ii = 1 to LOCshapeArray.count do\n"
      LOCexe += "            (\n"
      LOCexe += "              if isValidNode LOCshapeArray[ii] and superClassOf LOCshapeArray[ii] == shape and LOCelemArray.count > 0 then\n"
      LOCexe += "              (\n"
      LOCexe += "                LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[24]\n"
      LOCexe += "                LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[24]\n"
      LOCexe += "                local LOCsurfNode = undefined\n"
      LOCexe += "                local LOCsplineIndex = 1\n"
      LOCexe += "\n"
      LOCexe += "                --- Ensure that Parent Shape is an editable spline\n"
      LOCexe += "                DYNFUNcheckIsSplineShape LOCshapeArray[ii]\n"
      LOCexe += "\n"
      LOCexe += "                --- Get Start Station of Current Shape\n"
      LOCexe += "                local LOCstartStation = getAppData LOCshapeArray[ii] 426\n"
      LOCexe += "                if classOf LOCstartStation == string then LOCstartStation = LOCstartStation as float\n"
      LOCexe += "                if classOf LOCstartStation != float  then LOCstartStation = 0.0\n"
      LOCexe += "\n"
      LOCexe += "                --- Check amount of available space for each element in Object Placement Style\n"
      LOCexe += "                local LOCobjCnt = 0.0\n"
      LOCexe += "                DYNobjectPlacer.LOCspaceCheckProceedSwitch = true\n"
      LOCexe += "                local LOCinsertPositions = DYNFUNpreProcessOPStyle LOCelemArray (curveLength LOCshapeArray[ii]) LOCstartStation\n"
      LOCexe += "                for iii = 1 to LOCinsertPositions.count do LOCobjCnt += LOCinsertPositions[iii].count\n"
      LOCexe += "\n"
      LOCexe += "                --- Place Objects\n"
      LOCexe += "                if DYNobjectPlacer.LOCspaceCheckProceedSwitch then\n"
      LOCexe += "                (\n"
      LOCexe += "                  --- Fill Object INI File Arrays then Place Objects\n"
      LOCexe += "                  local LOCflagArray = #(); LOCflagArray.count = LOCelemArray.count; for ii = 1 to LOCflagArray.count do LOCflagArray[ii] = true\n"
      LOCexe += "                  local LOCnodeArray = #(); LOCnodeArray.count = LOCelemArray.count; for ii = 1 to LOCnodeArray.count do LOCnodeArray[ii] = #()\n"
      LOCexe += "                  LOCnodeArray = DYNobjectPlacer.DYNFUNplaceObjects LOCshapeArray[ii] LOCinsertPositions LOCsurfNode 1 LOCprogressBarCtrl LOCelemArray LOCflagArray LOCnodeArray LOCobjCnt LOCstatusLabelCtrl LOCsceneMats (if DYNINIchainageLoop == \"0\" then false else true) (if DYNINIrotateWheels == \"0\" then false else true) DYNresourceList.LOCresourceKitMode\n"
      LOCexe += "                )\n"
      LOCexe += "                else (print DYNuiResourcesErrorsWarnings[73])\n"
      LOCexe += "              )\n"
      LOCexe += "            )\n"
      LOCexe += "            LOCprogressBarCtrl.value = 0; LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[51]\n"
      LOCexe += "          )\n"
      LOCexe += "        )\n"
      LOCexe += "\n"
      LOCexe += "        ---- Apply Road Marking Style --------------------------------------------------------------------------------------\n"
      LOCexe += "        --------------------------------------------------------------------------------------------------------------------\n"
      LOCexe += "        if doesFileExist LOCstyleFile and LOCstyleType == \".rms\" then\n"
      LOCexe += "        (\n"
      LOCexe += "          LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[10]\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Shape Label Wildcard Array from Param File Contents\n"
      LOCexe += "          local LOCelemArray = DYNFUNparsePARAMfile LOCstyleFile \"3001\"\n"
      LOCexe += "          local LOCmarkArray = #() ; LOCmarkArray[LOCelemArray.count] = undefined\n"
      LOCexe += "          for ii = 1 to LOCmarkArray.count do (LOCmarkArray[ii] = LOCelemArray[ii][1])\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Road Marking Object if wildcard matches pattern in LOCshapeArray\n"
      LOCexe += "          for ii = 1 to LOCmarkArray.count do\n"
      LOCexe += "          (\n"
      LOCexe += "            local LOCparentArray = #()\n"
      LOCexe += "            local LOCmarkDims    = try ([LOCelemArray[ii][2] as float, LOCelemArray[ii][3] as float, LOCelemArray[ii][4] as float]) catch ([10.0,0.0,0.1])\n"
      LOCexe += "            local LOCmarkColor   = try (color (LOCelemArray[ii][6] as integer) (LOCelemArray[ii][7] as integer) (LOCelemArray[ii][8] as integer)) catch (DYNINImarkingColor)\n"
      LOCexe += "            local LOCmarkInst    = try (if (LOCelemArray[ii][5] as integer) == 1 then true else false) catch (false)\n"
      LOCexe += "            local LOCcentreGap   = try (LOCelemArray[ii][11] as float) catch (0.0)\n"
      LOCexe += "            local LOChOffset     = try (LOCelemArray[ii][12] as float) catch (0.0)\n"
      LOCexe += "\n"
      LOCexe += "            for iii = 1 to LOCshapeArray.count do\n"
      LOCexe += "            (\n"
      LOCexe += "              if isValidNode LOCshapeArray[iii] and superClassOf LOCshapeArray[iii] == shape then\n"
      LOCexe += "              (\n"
      LOCexe += "                LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[10]\n"
      LOCexe += "                LOCprogressBarCtrl.value = ((ii * iii) as float) / ((LOCshapeArray.count * LOCmarkArray.count) as float) * 100.0\n"
      LOCexe += "\n"
      LOCexe += "                if (matchPattern LOCshapeArray[iii].name pattern:LOCmarkArray[ii] ignoreCase:true) then (append LOCparentArray LOCshapeArray[iii])\n"
      LOCexe += "              )\n"
      LOCexe += "            )\n"
      LOCexe += "            DYNFUNcreateMarks LOCparentArray LOCstyleFile rootNode.DYNrootNodeStore.markVshift rootNode.DYNrootNodeStore.markFreeze (DYNFUNgetLocalTime()) LOCmarkColor LOCmarkDims false (not DYNINIallowMultMarks) LOCsceneMats undefined LOCmarkInst LOCcentreGap LOChOffset 0.0\n"
      LOCexe += "          )\n"
      LOCexe += "          LOCprogressBarCtrl.value = 0\n"
      LOCexe += "          LOCstatusLabelCtrl.text  = DYNuiResourcesStatusMessages[11]\n"
      LOCexe += "        )\n"
      LOCexe += "\n"
      LOCexe += "        ---- Apply Rail Object Style ---------------------------------------------------------------------------------------\n"
      LOCexe += "        --------------------------------------------------------------------------------------------------------------------\n"
      LOCexe += "        if doesFileExist LOCstyleFile and LOCstyleType == \".ros\" then\n"
      LOCexe += "        (\n"
      LOCexe += "          LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[43]\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Shape Label Wildcard Array from Param File Contents\n"
      LOCexe += "          local LOCelemArray = DYNFUNparsePARAMfile LOCstyleFile \"5000\"\n"
      LOCexe += "          local LOCrailArray = #() ; LOCrailArray[LOCelemArray.count] = undefined\n"
      LOCexe += "          for ii = 1 to LOCrailArray.count do (LOCrailArray[ii] = LOCelemArray[ii][10])\n"
      LOCexe += "\n"
      LOCexe += "          --- Make Rail Object if wildcard matches pattern in LOCshapeArray\n"
      LOCexe += "          for ii = 1 to LOCrailArray.count do\n"
      LOCexe += "          (\n"
      LOCexe += "            local LOCparentArray = #()\n"
      LOCexe += "            for iii = 1 to LOCshapeArray.count do\n"
      LOCexe += "            (\n"
      LOCexe += "              if isValidNode LOCshapeArray[iii] and superClassOf LOCshapeArray[iii] == shape then\n"
      LOCexe += "              (\n"
      LOCexe += "                LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[43]\n"
      LOCexe += "                LOCprogressBarCtrl.value = ((ii * iii) as float) / ((LOCshapeArray.count * LOCrailArray.count) as float) * 100.0\n"
      LOCexe += "\n"
      LOCexe += "                if (matchPattern LOCshapeArray[iii].name pattern:LOCrailArray[ii] ignoreCase:true) then (append LOCparentArray LOCshapeArray[iii])\n"
      LOCexe += "              )\n"
      LOCexe += "            )\n"
      LOCexe += "            DYNFUNcreateRails LOCparentArray LOCstyleFile (DYNFUNgetLocalTime()) (not DYNINIallowMultRails) LOCsceneMats LOCelemArray[ii] undefined LOCelemArray[ii][5]\n"
      LOCexe += "          )\n"
      LOCexe += "          LOCprogressBarCtrl.value = 0; LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[44]\n"
      LOCexe += "        )\n"
      LOCexe += "\n"
      LOCexe += "        ---- Apply Swept Object Style --------------------------------------------------------------------------------------\n"
      LOCexe += "        --------------------------------------------------------------------------------------------------------------------\n"
      LOCexe += "        if doesFileExist LOCstyleFile and LOCstyleType == \".sos\" then\n"
      LOCexe += "        (\n"
      LOCexe += "          if (DYNFUNsosPreFlight LOCstyleFile) then\n"
      LOCexe += "          (\n"
      LOCexe += "            LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[47]\n"
      LOCexe += "            DYNsosParams.LOCsosGlobalArray = (DYNFUNparsePARAMfile LOCstyleFile \"2000\")[1]\n"
      LOCexe += "            append DYNsosParams.LOCsosGlobalArray ((DYNFUNparsePARAMfile LOCstyleFile \"2010\")[1][1])\n"
      LOCexe += "            DYNsosParams.LOCsosElemArray   = DYNFUNparsePARAMfile LOCstyleFile \"2001\"\n"
      LOCexe += "            if DYNsosParams.LOCsosGlobalArray.count > 0 then\n"
      LOCexe += "            (\n"
      LOCexe += "              DYNsosParams.LOCobjMod1 = (Civil_View_Swept_Object ui:On total:DYNsosParams.LOCsosElemArray.count)\n"
      LOCexe += "              DYNsosParams.LOCobjMod2 = (Civil_View_Divide_Spline ui:On)\n"
      LOCexe += "              DYNsweptObjects.DYNFUNmodifySweptObject DYNsosParams.LOCobjMod1 DYNsosParams.LOCsosGlobalArray DYNsosParams.LOCsosElemArray DYNsosParams \"DYNsosParams\"\n"
      LOCexe += "              DYNFUNmodifyDivider DYNsosParams.LOCobjMod2 DYNsosParams.LOCobjMod1.spacing DYNsosParams.LOCobjMod1.normalize\n"
      LOCexe += "              for ii = 1 to LOCshapeArray.count do\n"
      LOCexe += "              (\n"
      LOCexe += "                LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[47]\n"
      LOCexe += "                if (isValidNode LOCshapeArray[ii]) and superClassOf LOCshapeArray[ii] == shape then\n"
      LOCexe += "                (\n"
      LOCexe += "                  DYNsweptObjects.DYNFUNcreateSweptObjects #(LOCshapeArray[ii]) LOCstyleFile DYNsosParams.LOCobjMod1 DYNsosParams.LOCobjMod2 DYNmatNameSurfaces (if DYNsosParams.LOCsosGlobalArray[3] < 0.0 then true else false)\n"
      LOCexe += "                )\n"
      LOCexe += "              )\n"
      LOCexe += "            )\n"
      LOCexe += "            DYNsosParams.LOCsosGlobalArray = #()\n"
      LOCexe += "            DYNsosParams.LOCsosElemArray   = #()\n"
      LOCexe += "            DYNsosParams.LOCobj            = undefined\n"
      LOCexe += "            DYNsosParams.LOCobjMod1        = undefined\n"
      LOCexe += "            DYNsosParams.LOCobjMod2        = undefined\n"
      LOCexe += "          )\n"
      LOCexe += "          else LOCproceedSwitch = false\n"
      LOCexe += "          LOCprogressBarCtrl.value = 0; LOCstatusLabelCtrl.text = DYNuiResourcesStatusMessages[48]\n"
      LOCexe += "        )\n"
      LOCexe += "      )\n"
      LOCexe += "      redrawViews()\n"
      LOCexe += "    )\n"
      LOCexe += "    DYNFUNloadVSPnodeCallBacks true\n"
      LOCexe += "    DYNFUNnodeCreatedCallback()\n"
      LOCexe += "    DYNproperties.DYNFUNscreenSelectionToList()\n"
      LOCexe += "\n"
      LOCexe += "    destroyDialog LOCprogressPanel\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNresourceList.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNresourceList.LOCpopupMenu
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dotNetControl dnResources "System.Windows.Forms.ListView" height:300 width:(DYNiniExplorerWidth - 23) align:#center
  button BUDYNupdate   width:127 align:#center

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNresourceList open do
  (
    DYNresourceList.title          = DYNuiRolloutNames[61]
    BUDYNupdate.text               = DYNuiResourcesButtons[29]

    DYNFUNdnListViewStyle dnResources false true

    dnResources.multiSelect        = false
    dnResources.AllowColumnReorder = false
    dnResources.sorting            = DYNdnSortOrderClass.ascending
    dnResources.smallImageList     = DYNdnSmImageList

    local LOCcol1                  = dnResources.Columns.add DYNuiResourcesLvColumns[9] 300
    LOCcol1.textAlign              = DYNdnHorAlignClass.left

    DYNFUNpopulateResourceList LOCobjectSwitch undefined LOCresourceType LOCresourceKitMode
  )

  on DYNresourceList close do
  (
    dnResources.Items.clear()
  )

  on dnResources MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNresourcePopUpMenu dnResources
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )
  )

  on BUDYNupdate   pressed do (DYNFUNpopulateResourceList LOCobjectSwitch undefined LOCresourceType LOCresourceKitMode)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCsGoT4sa6BqhUslJ60/A+s2FLe3cLaJUHy
-- oKA92uStKv9VrWU3A9kluvmfTr0VOl8rRzUz8aZrCcFRrC0sHCa5VHHQKhmxf8H9
-- 9ZFnnczbHaAdLtKzVnhH5uTgxYGEANgWLgKUl0/J/p9oJBAt76esL3OZ3BB4bVnb
-- oZZVcUlb9LO01+zUAKAsY4iqOcGh+PhPDRG7zrQcc2Z19k9Fc/m2G5SVt8oB4Jaj
-- qyRGjxOOj5wdLheI1x+ysTcR5PiGH7slgU5oDsJVnGygHuVaHzh7gykjwJt8m4n4
-- 1mPVhUIp7vyn9x6MrIELYZwXLie62g75fscTWcrxDYp3aTyzbMKS
-- -----END-SIGNATURE-----